function batch_process(top_folder,cell_array_of_files_names,output_name)
%big_table_puncta = table();
%big_table_all = table();

big_cell_puncta = {};
big_cell_all = {};

mkdir(output_name);

parfor i=1:length(cell_array_of_files_names)
    [~,im_name,~] = fileparts(cell_array_of_files_names{i});
    mkdir([output_name filesep im_name]);
    [puncta_coordinates,all_coordinates] = storm_puncta_analysis_per_image([top_folder filesep cell_array_of_files_names{i}],[output_name filesep im_name]);
    puncta_coordinates.Image = repmat(i,height(puncta_coordinates),1);
    all_coordinates.Image = repmat(i,height(all_coordinates),1);
    big_cell_puncta{i} = puncta_coordinates;
    big_cell_all{i} = all_coordinates;
end

big_table_puncta = {};
big_table_all = {};
for i=1:length(cell_array_of_files_names)
    big_table_puncta = [big_table_puncta;big_cell_puncta{i}];
    big_table_all = [big_table_all;big_cell_all{i}];
end

writetable(big_table_puncta, [output_name filesep output_name '_only_puncta_coordinates.xlsx']);
writetable(big_table_all, [output_name filesep output_name '_all_coordinates.xlsx']);
end

%l = dir('*_border.tif')
%batch_pro5cess('.',{l.name},'crsh')
